"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Route_1 = __importDefault(global[Symbol.for('ioc.use')]("Adonis/Core/Route"));
Route_1.default.get('/', async ({ view }) => {
    return view.render('welcome');
});
Route_1.default.get('/verificar/:token', 'PagesController.verificar');
Route_1.default.get('/confirmar-cuenta/:token', 'ApiController.confirmarCuenta');
Route_1.default.post('/confirmar-cuenta/reenvio', 'ApiController.reenviarConfirmacion');
Route_1.default.get('/password/reset/:token', 'PagesController.mostrarPasswordReset');
Route_1.default.post('/password/reset', 'ApiController.passwordReset');
Route_1.default.post('/password/reset/email', 'ApiController.enviarResetEmail');
Route_1.default.post('api/crearUsuario', 'ApiController.nuevoUsuario');
Route_1.default.post('api/editarPerfil', 'ApiController.editaPerfil')/*.middleware('auth')*/;
Route_1.default.post('api/crearPais', 'ApiController.creaPais');
Route_1.default.post('api/crearCV', 'ApiController.creaCV');
Route_1.default.post('api/crearEmbajadaConsulado', 'ApiController.creaEmbajadaConsulado');
Route_1.default.post('api/crearTipoViaje', 'ApiController.creaTiposViaje');
Route_1.default.post('api/crearMotivoViaje', 'ApiController.creaMotivosViaje');
Route_1.default.post('api/nuevoViaje', 'ApiController.nuevoViaje');
Route_1.default.post('api/nuevaVacunaPersona', 'ApiController.nuevaVacunaPersona')/*.middleware('auth')*/;
Route_1.default.get('/login', 'ApiController.login');
Route_1.default.post('/login', 'ApiController.login');
Route_1.default.post('/logout', 'ApiController.logout')/*.middleware('auth')*/;
Route_1.default.get('api/dameDatosParaEditarPerfil/:idUsuario', 'ApiController.dameDatosParaEditarPerfil')/*.middleware('auth')*/;
Route_1.default.get('api/dameCps', 'ApiController.dameCPostales');
Route_1.default.get('api/damePaises', 'ApiController.damePaises');
Route_1.default.get('api/damePaisConcreto/:idPais','ApiController.damePaisConcreto');
Route_1.default.get('api/dameCV', 'ApiController.dameCV');
Route_1.default.get('api/dameEmbajadaConsulado', 'ApiController.dameEmbajadasConsulados');
Route_1.default.get('api/dameTiposViaje', 'ApiController.dameTiposViaje');
Route_1.default.get('api/dameMotivosViaje', 'ApiController.dameMotivosViaje');
Route_1.default.get('api/dameListaDeVacunas', 'ApiController.dameListaDeVacunas');
Route_1.default.get('api/dameViajesDeUsuario/:idUsuario', 'ApiController.dameViajesDeUsuario')/*.middleware('auth')*/;
Route_1.default.get('api/dameViajesActivos/:idUsuario', 'ApiController.dameViajesActivos')/*.middleware('auth')*/;
Route_1.default.get('api/dameViajeConcreto/:idViaje', 'ApiController.dameViajeConcreto')/*.middleware('auth')*/;
Route_1.default.get('api/dameVacunasPersona/:idUsuario', 'ApiController.dameVacunasPersona')/*.middleware('auth')*/;
Route_1.default.get('api/dameVacunasPendientesPersona/:idUsuario', 'ApiController.dameVacunasPendientesPersona')/*.middleware('auth')*/;
//# sourceMappingURL=routes.js.map