"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Validator_1 = global[Symbol.for('ioc.use')]("Adonis/Core/Validator");
const Database_1 = __importDefault(global[Symbol.for('ioc.use')]("Adonis/Lucid/Database"));
const Usuario_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/Usuario"));
const Persona_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/Persona"));
const PasswordReset_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/PasswordReset"));
const Pais_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/Pais"));
const CentrosVacunaciones_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/CentrosVacunaciones"));
const TiposViaje_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/TiposViaje"));
const MotivosViaje_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/MotivosViaje"));
const Viaje_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/Viaje"));
const EtapasViaje_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/EtapasViaje"));
const Grupo_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/Grupo"));
const EmbajadasConsulados_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/EmbajadasConsulados"));
const Mail_1 = __importDefault(global[Symbol.for('ioc.use')]("Adonis/Addons/Mail"));
const Env_1 = __importDefault(global[Symbol.for('ioc.use')]("Adonis/Core/Env"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const RVacunasPersona_1 = __importDefault(global[Symbol.for('ioc.use')]("App/Models/RVacunasPersona"));
class ApiController {
    async nuevoUsuario({ request, response }) {
        const newUserSchema = Validator_1.schema.create({
            email: Validator_1.schema.string({ trim: true }, [
                Validator_1.rules.email(),
                Validator_1.rules.unique({ table: "usuarios", column: "email" }),
            ]),
            password: Validator_1.schema.string({ trim: true }),
            nombrePersona: Validator_1.schema.string({ trim: true }, []),
            apellidosPersona: Validator_1.schema.string({ trim: true }, []),
            genero: Validator_1.schema.string({ trim: true }, []),
            telefono: Validator_1.schema.string({ trim: true }, [
                Validator_1.rules.unique({
                    column: 'telefono',
                    table: "personas"
                }),
            ]),
            fechaNacimiento: Validator_1.schema.date({}),
            c_postal: Validator_1.schema.string({ trim: true }, []),
            pais: Validator_1.schema.number(),
        });
        try {
            const payload = await request.validate({
                schema: newUserSchema,
                messages: {
                    'password.required': 'Introduce un password válido',
                    'email.required': 'Introduce un e-mail válido',
                    'email.email': 'Introduce un e-mail válido',
                    'email.unique': 'e-mail en uso',
                    'nombrePersona.required': 'Introduce un nombre de usuario válido',
                    'nombrePersona.maxLength': 'No puede exceder de 50 caracteres',
                    'nombrePersona.alpha': 'El nombre no puede contener números',
                    'apellidosPersona.required': 'Introduce unos apellidos válidos',
                    'apellidosPersona.maxLength': 'No puede exceder de 100 caracteres',
                    'apellidosPersona.alpha': 'Los apellidos no pueden contener números',
                    'genero.maxLength': 'No puede exceder de 10 caracteres',
                    'telefono.required': 'Introduce un teléfono válido',
                    'telefono.unique': 'No puedes usar ese número',
                    'telefono.maxLength': 'No puede exceder de 20 caracteres',
                }
            });
            let datosPersona = {
                nombre: payload.nombrePersona,
                apellidos: payload.apellidosPersona,
                genero: payload.genero,
                c_postal: payload.c_postal,
                telefono: payload.telefono,
                pais: payload.pais,
                f_nacimiento: payload.fechaNacimiento.toJSDate()
            };
            const persona = await Persona_1.default.create(datosPersona);
            let datosUsuario = {
                persona: persona.id,
                email: payload.email,
                password: payload.password,
                email_verif: false
            };
            const usuario = await Usuario_1.default.create(datosUsuario);
            const token = jsonwebtoken_1.default.sign({ email: usuario.email }, Env_1.default.get('SECRET'), {
                expiresIn: 60 * 60 * 24 * 3,
            });
            await Mail_1.default.send((message) => {
                message
                    .from('a.gallego1981@zohomail.eu')
                    .to(usuario.email)
                    .subject('Bienvenido!')
                    .htmlView('emails/verify', { name: persona.nombre + " " + persona.apellidos, url: 'https://ulises.digentropia.com/confirmar-cuenta/' + token });
            });
            response.ok({
                estado: "Éxito",
                data: "Usuario " + usuario.email + " introducido correctamente con id: " + usuario.id + " token ",
                data1: "Email de confirmación enviado, por favor, revisa la bandeja de entrada o de SPAM del correo: " + usuario.email
            });
        }
        catch (error) {
            response.badRequest({
                estado: "Fallo",
                data: error.messages
            });
        }
    }
    async confirmarCuenta({ params, response }) {
        const { token } = params;
        var respuesta = "";
        var payload;
        try {
            payload = await jsonwebtoken_1.default.verify(token, Env_1.default.get('SECRET'));
            const consulta_R = await Database_1.default.from('usuarios')
                .select('id').where('email', '=', payload.email);
            if (consulta_R.length > 0) {
                const usuario_id = consulta_R[0]['id'];
                const usuario = await Usuario_1.default.findOrFail(usuario_id);
                if (usuario.email_verif) {
                    respuesta = 'La cuenta ya estaba verificada';
                }
                else {
                    usuario.email_verif = true;
                    await usuario.save();
                    respuesta = 'Cuenta verificada con éxito';
                }
            }
            else {
                respuesta = 'No existe ningún usuario con ese email';
            }
            return respuesta;
        }
        catch (err) {
            response.badRequest('Token incorrecto o ha expirado');
        }
    }
    async reenviarConfirmacion({ request, response }) {
        const newConfirmationSchema = Validator_1.schema.create({
            email: Validator_1.schema.string({ trim: true }, [
                Validator_1.rules.email(),
                Validator_1.rules.required()
            ])
        });
        try {
            const payload = await request.validate({
                schema: newConfirmationSchema,
                messages: {
                    'email.required': 'Introduce un email correcto'
                }
            });
            let email_entrante = payload.email;
            const usuario = await Usuario_1.default.findBy('email', email_entrante);
            if (!usuario) {
                response.ok({
                    estado: "Fallo",
                    data: "El email introducido no se encuentra asociado a ningún usuario"
                });
            }
            else if (!usuario.email_verif) {
                const token = jsonwebtoken_1.default.sign({ email: usuario.email }, Env_1.default.get('SECRET'), {
                    expiresIn: 60 * 60 * 24 * 3,
                });
                const persona = await Persona_1.default.findOrFail(usuario.persona);
                await Mail_1.default.send((message) => {
                    message
                        .from('a.gallego1981@zohomail.eu')
                        .to(usuario.email)
                        .subject('Reenvío confirmación!')
                        .htmlView('emails/verify', { name: persona.nombre + " " + persona.apellidos, url: 'https://ulises.digentropia.com/confirmar-cuenta/' + token });
                });
                response.ok({
                    estado: "Éxito",
                    data: "Email de Confirmación reenviado, por favor, revisa la bandeja de entrada o de SPAM del correo: " + usuario.email
                });
            }
            else {
                response.ok({
                    estado: "Éxito",
                    data: "El correo " + usuario.email + " ya estaba verificado anteriormente. Ya puede iniciar sesión"
                });
            }
        }
        catch (err) {
            response.badRequest({
                estado: "Fallo",
                data: err.messages
            });
        }
    }
    async login({ request, response, auth }) {
        //const { email, password } = request.all();
       
            
        
        const datosEntrantes = await request.all();
        const rememberMe = true;
        /*let email_entrante = "fluture.desarrollos@gmail.com";
        let pass_entrante = "hola123";*/
        
        let email_entrante = datosEntrantes.email;
        let pass_entrante = datosEntrantes.password;
        let email = datosEntrantes.email;
        let password = datosEntrantes.password;
        try {
            
            const usuario = await Usuario_1.default.findBy('email', email_entrante);
            if (usuario != null) {
                if (!usuario.email_verif) {
                    response.ok({
                        estado: "Fallo",
                        data: "El correo " + usuario.email + " no está verificado. Compruebe su bandeja de correo y verifiquelo para poder iniciar sesión"
                    });
                }
                else {
                    /*const token = await auth.attempt(email, password, rememberMe);*/
                    const token = await auth.use('api').attempt(email_entrante, pass_entrante);
                    const info_usuario = await auth.attempt(email_entrante, pass_entrante,rememberMe);
                    const persona = await Persona_1.default.findOrFail(usuario.persona);
                    return response.ok({
                        estado: "Éxito",
                        data: token,
                        data2: info_usuario,
                        data1: "Bienvenido " + persona.nombre + " " + persona.apellidos,
                        data3: request
                    });
                }
            }
            else {
                return response.badRequest({ 
                    estado: "Fallo",
                    data: email + " " + password + " email y/o password incorrecto/s" 
                });
            }
        }
        catch (error) {
            if (email === undefined) {
                response.badRequest({
                    estado: "Fallo",
                    data: 'Sesión no iniciada. No se puede acceder a este contenido. Error: '+ error.message
                });
            }
            else {
                 return response.badRequest({ 
                    estado: "Fallo",
                    data: email + " " + password + " email y/o password incorrecto/s" 
                });
            }
        }
    }
    async logout({ auth, response }) {
        await auth.logout();
        return response.ok({ 
            estado: "Éxito",
            data: 'Se ha cerrado sesión' 
        });
    }
    async enviarResetEmail({ request, response }) {
        const newConfirmationSchema = Validator_1.schema.create({
            email: Validator_1.schema.string({ trim: true }, [
                Validator_1.rules.email(),
                Validator_1.rules.required()
            ])
        });
        try {
            const payload = await request.validate({
                schema: newConfirmationSchema,
                messages: {
                    'email.required': 'Introduce un email correcto'
                }
            });
            let email_entrante = payload.email;
            const usuario = await Usuario_1.default.findBy('email', email_entrante);
            if (!usuario) {
                response.ok({
                    estado: "Fallo",
                    data: "El email introducido no se encuentra asociado a ningún usuario"
                });
            }
            else {
                await PasswordReset_1.default.query().where('email', usuario.email).delete();
                const token = jsonwebtoken_1.default.sign({ email: usuario.email }, Env_1.default.get('SECRET'), {
                    expiresIn: 60 * 60 * 24 * 3,
                });
                await PasswordReset_1.default.create({
                    email: usuario.email,
                    token: token
                });
                const persona = await Persona_1.default.findOrFail(usuario.persona);
                await Mail_1.default.send((message) => {
                    message
                        .from('a.gallego1981@zohomail.eu')
                        .to(usuario.email)
                        .subject('Reestablecer contraseña')
                        .htmlView('emails/reset_password', { name: persona.nombre + " " + persona.apellidos, url: 'https://ulises.digentropia.com/password/reset/' + token });
                });
                response.ok({
                    estado: "Éxito",
                    data: "Email para reestablecer contraseña enviado, por favor, revisa la bandeja de entrada o de SPAM del correo: " + usuario.email
                });
            }
        }
        catch (err) {
            response.badRequest({
                estado: "Fallo",
                data: err.messages
            });
        }
    }
    async passwordReset({ response, request, session }) {
        const newConfirmationSchema = Validator_1.schema.create({
            token: Validator_1.schema.string({ trim: true }, [
                Validator_1.rules.required()
            ]),
            password: Validator_1.schema.string([
                Validator_1.rules.confirmed('passwordConfirm'),
                Validator_1.rules.minLength(4)
            ]),
            passwordConfirm: Validator_1.schema.string([])
        });
        try {
            await request.validate({
                schema: newConfirmationSchema,
                messages: {
                    'password.required': 'Introduce una contraseña válida',
                    'password.confirmed': 'Las contraseñas deben coincidir',
                    'passwordConfirm.confirmed': 'Las contraseñas deben coincidir',
                    'passwordConfirm.required': 'Introduce una confirmación de contraseña válida',
                }
            });
            try {
                const verif_token = jsonwebtoken_1.default.verify(request.input('token'), Env_1.default.get('SECRET'));
                if (verif_token) {
                    const usuario = await Usuario_1.default.findBy('email', verif_token['email']);
                    if (!usuario) {
                        session.flash('notification', 'Usuario no encontrado');
                        return response.redirect('back');
                    }
                    const passwordReset = await PasswordReset_1.default.query()
                        .where('email', usuario.email)
                        .where('token', request.input('token'))
                        .first();
                    if (!passwordReset) {
                        session.flash('notification', 'Petición de restablecer contraseña no encontrada');
                        return response.redirect('back');
                    }
                    usuario.password = request.input('password');
                    await usuario.save();
                    await passwordReset.delete();
                    session.flash('notification', 'Contraseña reestablecida con éxito ya puede iniciar sesión en la App con su nueva contraseña');
                    return response.redirect('back');
                }
            }
            catch (errores) {
                session.flash('notification', 'Enlace no válido o ha expirado');
                return response.redirect('back');
            }
        }
        catch (error) {
            session.flash(error.messages);
            return response.redirect('back');
        }
    }
    async editaPerfil({ request, response }) {
        const datosEntrantes = await request.all();
        const consulta_R = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', datosEntrantes.idUsuario);
        var arr_consulta = Object.values(consulta_R);
        const updateUserSchema = Validator_1.schema.create({
            nombrePersona: Validator_1.schema.string({ trim: true }, []),
            apellidosPersona: Validator_1.schema.string({ trim: true }, []),
            genero: Validator_1.schema.string({ trim: true }, []),
            /*telefono: Validator_1.schema.string({ trim: true }, [
                Validator_1.rules.unique({
                    column: 'telefono',
                    table: "personas"
                }),
            ]),*/
            fechaNacimiento: Validator_1.schema.date({}),
            c_postal: Validator_1.schema.string({ trim: true }, []),
            pais: Validator_1.schema.number(),
        });
        try {
            const payload = await request.validate({
                schema: updateUserSchema,
                messages: {
                    'nombrePersona.required': 'Introduce un nombre de usuario válido',
                    'nombrePersona.maxLength': 'No puede exceder de 50 caracteres',
                    'nombrePersona.alpha': 'El nombre no puede contener números',
                    'apellidosPersona.required': 'Introduce unos apellidos válidos',
                    'apellidosPersona.maxLength': 'No puede exceder de 100 caracteres',
                    'apellidosPersona.alpha': 'Los apellidos no pueden contener números',
                    'genero.maxLength': 'No puede exceder de 10 caracteres',
                    'telefono.required': 'Introduce un teléfono válido',
                    'telefono.unique': 'No puedes usar ese número',
                    'telefono.maxLength': 'No puede exceder de 20 caracteres',
                }
            });
            let datosPersona = {
                nombre: payload.nombrePersona,
                apellidos: payload.apellidosPersona,
                genero: payload.genero,
                c_postal: payload.c_postal,
                telefono: datosEntrantes.telefono,
                pais: payload.pais,
                f_nacimiento: payload.fechaNacimiento.toJSDate()
            };
            const id_persona = arr_consulta[0]['persona'];
            const persona = await Persona_1.default.findOrFail(id_persona);
            persona.nombre = datosPersona.nombre;
            persona.apellidos = datosPersona.apellidos;
            persona.genero = datosPersona.genero;
            persona.c_postal = datosPersona.c_postal;
            persona.telefono = datosPersona.telefono;
            persona.pais = datosPersona.pais;
            persona.f_nacimiento = datosPersona.f_nacimiento;
            persona.save();
            response.ok({
                estado: "Éxito",
                data: "Usuario " + persona.nombre + " " + persona.apellidos + " editado correctamente"
            });
        }
        catch (error) {
            response.badRequest({
                estado: "Fallo",
                data: error.messages
            });
        }
    }
    async nuevoViaje({ response, request }) {
        const datosEntrantes = await request.all();
        const consulta_R = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', datosEntrantes.idUsuario);
        var arr_consulta = Object.values(consulta_R);
        if (arr_consulta.length > 0) {
            const consulta_R2 = await Database_1.default.from('personas')
                .select('nombre').where('id', '=', arr_consulta[0]['persona']);
            var arr_consulta_nombre_persona = Object.values(consulta_R2);
            const viajeSchema = Validator_1.schema.create({
                nombre: Validator_1.schema.string({ trim: true }, []),
                tipo: Validator_1.schema.number(),
                motivo: Validator_1.schema.number(),
                fInicio: Validator_1.schema.date(),
                fFin: Validator_1.schema.date(),
            });
            try {
                const payload = await request.validate({
                    schema: viajeSchema,
                    messages: {
                        'nombre.required': 'Introduce un nombre de usuario válido',
                        'nombre.maxLength': 'No puede exceder de 50 caracteres',
                        'nombre.alpha': 'El nombre no puede contener números',
                    }
                });
                let datosViaje = {
                    nombre: payload.nombre,
                    tipo: payload.tipo,
                    motivo: payload.motivo,
                    f_inicio: payload.fInicio.toJSDate(),
                    f_fin: payload.fFin.toJSDate(),
                };
                const viaje = await Viaje_1.default.create(datosViaje);
                var array_etapas = datosEntrantes.etapas;
                var array_etapas_creadas = [];
                for (var i = 0; i < array_etapas.length; i++) {
                    let datosEtapas = {
                        "pais": array_etapas[i]['pais'],
                        "viaje": viaje.id,
                        "f_inicio": array_etapas[i]['fIniEtapa'],
                        "f_fin": array_etapas[i]['fFinEtapa']
                    };
                    EtapasViaje_1.default.create(datosEtapas);
                    array_etapas_creadas.push(String("Etapa " + (i + 1) + " del viaje: " + viaje.id));
                }
                var array_personas_grupo = datosEntrantes.grupos;
                var array_grupos = [];
                let datosGrupo1 = {
                    "persona": arr_consulta[0]['persona'],
                    "viaje": viaje.id,
                    "promotor": arr_consulta[0]['persona']
                };
                Grupo_1.default.create(datosGrupo1);
                array_grupos.push(String("Persona 1 del grupo: " + arr_consulta_nombre_persona[0]['nombre'] + " con id: " + arr_consulta[0]['persona']));
                for (var i = 0; i < array_personas_grupo.length; i++) {
                    let datosGrupo = {
                        "persona": array_personas_grupo[i]['personaId'],
                        "viaje": viaje.id,
                        "promotor": arr_consulta[0]['persona']
                    };
                    Grupo_1.default.create(datosGrupo);
                    array_grupos.push(String("Persona " + (i + 2) + " del grupo: " + array_personas_grupo[i]['nombrePersona'] + " con id: " + array_personas_grupo[i]['personaId']));
                }
                response.ok({
                    estado: "Éxito",
                    data: "Viaje " + viaje.nombre + " añadido correctamente con id: " + viaje.id,
                    viaje: viaje.id,
                    etapas: array_etapas_creadas,
                    grupo: array_grupos
                });
            }
            catch (error) {
                response.badRequest({
                    estado: "Fallo",
                    data: error.messages
                });
            }
        }
        else {
            response.badRequest({
                estado: "Fallo",
                data: "No hay persona asociada al usuario " + datosEntrantes.idUsuario
            });
            /*return { "error": "No hay persona asociada al usuario " + datosEntrantes.idUsuario };*/
        }
    }
    async nuevaVacunaPersona({ response, request }) {
        const datosEntrantes = await request.all();
        const consulta_persona = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', datosEntrantes.idUsuario);
        if (consulta_persona.length > 0) {
            let datosVacunaPersona = {
                "persona": consulta_persona[0]['persona'],
                "vacuna": datosEntrantes.idVacuna,
                "dosis": datosEntrantes.dosis,
                "f_inoculacion": datosEntrantes.fInoculacion,
                "f_renovacion": datosEntrantes.fRenovacion
            };
            const vacuna_persona = await RVacunasPersona_1.default.create(datosVacunaPersona);
            if (vacuna_persona) {
                response.ok({
                    estado: "Éxito",
                    data: "Vacuna añadida correctamente a la persona id: " + vacuna_persona.persona
                });
            }
            else {
                response.badRequest({
                    estado: "Fallo",
                    data: "Ha habido un error de datos no es posible añadir la vacuna"
                });
               // return { "error": "Ha habido un error de datos no es posible añadir la vacuna" };
            }
        }
        else {
             response.badRequest({
                estado: "Fallo",
                data: "No hay persona asociada al usuario " + datosEntrantes.idUsuario
            });
          //  return { "error": "No hay persona asociada al usuario " + datosEntrantes.idUsuario };
        }
    }
    async dameDatosParaEditarPerfil({ params, response }) {
        const consulta_R = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', params.idUsuario);
        var arr_consulta = Object.values(consulta_R);
        if (arr_consulta.length > 0) {
            const id_persona = arr_consulta[0]['persona'];
            const persona = await Persona_1.default.findOrFail(id_persona);
            response.ok({
                estado: "Éxito",
                data: {
                    "nombre": persona.nombre,
                    "apellidos": persona.apellidos,
                    "genero": persona.genero,
                    "cPostal": persona.c_postal,
                    "telefono": persona.telefono,
                    "pais": persona.pais,
                    "fNacimiento": persona.f_nacimiento
                }
            });
        }
        else {
            response.badRequest({
                estado: "Fallo",
                data: "No hay persona asociada al usuario " + params.idUsuario
            });
            //return { "error": "No hay persona asociada al usuario " + params.idUsuario };
        }
    }
    async dameCPostales({ response }) {
        try {
            const lista_cps = await Database_1.default.from('cp_geo')
                .select('id', 'cp', 'localidad', 'provincia');
            response.ok({ 
                estado: "Éxito",    
                data: lista_cps 
            });
        } catch (error) {
            // return error.message
            response.badRequest({ 
                estado: "Fallo",    
                data: error.message 
            });
        }
    }
    async damePaises({ response }) {
        /*const lista_paises = await Database_1.default.from('pais')
            .select('id', 'nombre', 'name', 'nom', 'gps_latitud', 'gps_longitud');
        if (lista_paises) {
            response.ok({ lista_paises });
        }
        else {
            return "no rula";
        }*/
         try {
            const lista_paises = await Database_1.default.from('pais')
                .select('id', 'nombre', 'name', 'nom', 'gps_latitud', 'gps_longitud');

                response.ok({
                    estado: "Éxito",
                    data: lista_paises
                });
        } catch (error) {
            // return error.message
            response.badRequest({
                estado: "Fallo",
                data: error.message
            });
        }
    }
    async damePaisConcreto({ response, params }) {
        try {
            const lista_paises = await Database_1.default.from('pais')
                .select('id', 'nombre', 'name', 'nom', 'gps_latitud', 'gps_longitud')
                .where('id',params.idPais);

                response.ok({
                    estado: "Éxito",
                    data: lista_paises
                })
        } catch (error) {
            // return error.message
            response.badRequest({
                estado: "Fallo",
                data: error.message
            });
        }


    }
    async dameCV({ response }) {
        const lista_cv = await Database_1.default.from('centros_vacunaciones');
        if(lista_cv){
            response.ok({
                estado: "Éxito",
                data: lista_cv           
            });
        }else {
            response.badRequest({
                estado: "Fallo",
                data: "Información no disponible"
            });
        }
    }
    async dameEmbajadasConsulados({ response }) {
        const lista_embajadas_consulados = await Database_1.default.from('embajadas_consulados');
        if(lista_embajadas_consulados){
            response.ok({
                estado: "Éxito",
                data: lista_embajadas_consulados           
            });
        }else {
            response.badRequest({
                estado: "Fallo",
                data: "Información no disponible"
            });
        }
    }
    async dameTiposViaje({ response }) {
        const lista_tv = await Database_1.default.from('tipos_viajes');
        if(lista_tv){
            response.ok({
                estado: "Éxito",
                data: lista_tv           
            });
        }else {
            response.badRequest({
                estado: "Fallo",
                data: "Información no disponible"
            });
        }
    }
    async dameMotivosViaje({ response }) {
        const lista_mv = await Database_1.default.from('motivos_viajes');
        if(lista_mv){
            response.ok({
                estado: "Éxito",
                data: lista_mv           
            });
        }else {
            response.badRequest({
                estado: "Fallo",
                data: "Información no disponible"
            });
        }
    }
    async dameViajesDeUsuario({ response, params }) {
        const consulta_R = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', params.idUsuario);
        var arr_consulta = Object.values(consulta_R);
        if (arr_consulta.length > 0) {
            const id_persona = arr_consulta[0]['persona'];
            const consulta_id_viajes = await Database_1.default.from('grupos')
                .select('viaje').where('persona', '=', id_persona);
            var arr_consulta_id_viaje = Object.values(consulta_id_viajes);
            const fechaHoy = new Date();
            var consulta_viajes;
            var arr_consulta_viajes = [];
            for (var i = 0; i < arr_consulta_id_viaje.length; i++) {
                consulta_viajes = await Database_1.default.from('viajes')
                    .select('viajes.id as viajeId', 'viajes.nombre as viajeNombre', 'tipos_viajes.nombre as tipoViaje', 'motivos_viajes.nombre as motivoViaje', 'viajes.f_inicio', 'viajes.f_fin')
                    .innerJoin('tipos_viajes', 'viajes.tipo', '=', 'tipos_viajes.id')
                    .innerJoin('motivos_viajes', 'viajes.motivo', '=', 'motivos_viajes.id')
                    .where('viajes.id', '=', arr_consulta_id_viaje[i]['viaje']);
                arr_consulta_viajes.push(consulta_viajes);
            }
            response.ok({
                estado: "Éxito",
                data: {
                    arr_consulta_viajes
                },
                fechaHoy: fechaHoy
            });
        }
        else {
            response.badRequest({
                estado: "Fallo",
                data: "No hay persona asociada al usuario " + params.idUsuario
            });
            //return { "error": "No hay persona asociada al usuario " + params.idUsuario };
        }
    }
    async dameViajesActivos({ response, params }) {
        const consulta_R = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', params.idUsuario);
        var arr_consulta = Object.values(consulta_R);
        if (arr_consulta.length > 0) {
            const id_persona = arr_consulta[0]['persona'];
            const consulta_id_viajes = await Database_1.default.from('grupos')
                .select('viaje').where('persona', '=', id_persona);
            var arr_consulta_id_viaje = Object.values(consulta_id_viajes);
            const fechaHoy = new Date();
            var consulta_viajes;
            var arr_consulta_viajes = [];
            for (var i = 0; i < arr_consulta_id_viaje.length; i++) {
                consulta_viajes = await Database_1.default.from('viajes')
                    .select('viajes.id as viajeId', 'viajes.nombre as viajeNombre', 'tipos_viajes.nombre as tipoViaje', 'motivos_viajes.nombre as motivoViaje', 'viajes.f_inicio', 'viajes.f_fin')
                    .innerJoin('tipos_viajes', 'viajes.tipo', '=', 'tipos_viajes.id')
                    .innerJoin('motivos_viajes', 'viajes.motivo', '=', 'motivos_viajes.id')
                    .where('viajes.id', '=', arr_consulta_id_viaje[i]['viaje']);
                if (consulta_viajes[0]['f_inicio'] <= fechaHoy && consulta_viajes[0]['f_fin'] >= fechaHoy) {
                    arr_consulta_viajes.push(consulta_viajes);
                }
            }
            response.ok({
                estado: "Éxito",
                data: {
                    arr_consulta_id_viaje
                },
                data2: {
                    arr_consulta_viajes
                },
                fechaHoy: fechaHoy
            });
        }
        else {
            response.badRequest({
                estado: "Fallo",
                data: "No hay persona asociada al usuario " + params.idUsuario
            });
            //return { "error": "No hay persona asociada al usuario " + params.idUsuario };
        }
    }
    async dameViajeConcreto({ params, response }) {
        const fechaHoy = new Date();
        const consulta_viajes = await Database_1.default.from('etapas_viajes')
            .select('viajes.id as viajeId', 'viajes.nombre as viajeNombre', 'pais.id as idPais', 'pais.nombre as nombrePais', 'etapas_viajes.f_inicio as fInicio', 'etapas_viajes.f_fin as fFin')
            .innerJoin('viajes', 'viajes.id', '=', 'etapas_viajes.viaje')
            .innerJoin('pais', 'pais.id', '=', 'etapas_viajes.pais')
            .where('etapas_viajes.viaje', '=', params.idViaje);
        if (consulta_viajes.length > 0) {
            for (var i = 0; i < consulta_viajes.length; i++) {
                const consulta_embajadas = await Database_1.default.from('embajadas_consulados').where('pais', '=', consulta_viajes[i]['idPais']);
                consulta_viajes[i]['embajadas'] = consulta_embajadas;
                const consulta_emergencias = await Database_1.default.from('emergencias').where('pais', '=', consulta_viajes[i]['idPais']);
                consulta_viajes[i]['emergencias'] = consulta_emergencias;
                const consulta_recomendaciones = await Database_1.default.from('recomendaciones').where('pais', '=', consulta_viajes[i]['idPais']);
                consulta_viajes[i]['recomendaciones'] = consulta_recomendaciones;
                const consulta_leyes = await Database_1.default.from('leyes_paises').where('pais', '=', consulta_viajes[i]['idPais']);
                consulta_viajes[i]['leyes'] = consulta_leyes;
                const consulta_riesgos = await Database_1.default.from('riesgos as r')
                    .select('r.nombre as nombreRiesgo', 'r.descripcion as descRiesgo', 'rp.pais as idPais', 'rp.riesgo as idRiesgo')
                    .innerJoin('r_riesgos_paises as rp', 'r.id', '=', 'rp.riesgo')
                    .where('rp.pais', '=', consulta_viajes[i]['idPais']);
                consulta_viajes[i]['riesgos'] = consulta_riesgos;
                const consulta_precauciones = await Database_1.default.from('precauciones as p')
                    .select('p.nombre as nombrePrec', 'p.descripcion as descPrec', 'pp.pais as idPais', 'pp.precaucion as idRiesgo')
                    .innerJoin('r_precauciones_paises as pp', 'p.id', '=', 'pp.precaucion')
                    .where('pp.pais', '=', consulta_viajes[i]['idPais']);
                consulta_viajes[i]['precauciones'] = consulta_precauciones;
                const consulta_idiomas = await Database_1.default.from('idiomas as i')
                    .select('i.nombre as nombreIdioma', 'ip.pais as idPais', 'ip.idioma as idIdioma')
                    .innerJoin('r_idiomas_paises as ip', 'i.id', '=', 'ip.idioma')
                    .where('ip.pais', '=', consulta_viajes[i]['idPais']);
                consulta_viajes[i]['idiomas'] = consulta_idiomas;
            }
            response.ok({
                estado: "Éxito",
                data: {
                    consulta_viajes
                },
                fechaHoy: fechaHoy
            });
        }
        else {
            response.badRequest({
                estado: "Fallo",
                data: "No hay viaje asociado a la id: " + params.idViaje
            });
            //return { "error": "No hay viaje asociado a la id: " + params.idViaje };
        }
    }
    async dameListaDeVacunas({ response }) {

        const lista_vacunas = await Database_1.default.from('vacunas')

        if(lista_vacunas){
            response.ok({
                estado: "Éxito",
                data: lista_vacunas           
            })
        }else {
            response.badRequest({
                estado: "Fallo",
                data: "Información no disponible"
            })
        }
    }
    async dameVacunasPersona({ params, response }) {
        const fechaHoy = new Date();
        const consulta_persona = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', params.idUsuario);
        if (consulta_persona.length > 0) {
            const consulta_vacunas = await Database_1.default.from('vacunas as v')
                .select('v.id as vacunaId', 'v.nombre as vacunaNombre', 'v.descripcion as descripcionVacuna','rvc.dosis', 'v.cantidad_dosis as cantidadDosis', 'rvc.persona as idPersona', 'rvc.f_inoculacion as fInoculacion', 'v.periodo as periodo', 'rvc.f_renovacion as fRenovacion')
                .innerJoin('r_vacunas_personas as rvc', 'v.id', '=', 'rvc.vacuna')
                .where('rvc.persona', '=', consulta_persona[0]['persona']);
            response.ok({
                estado: "Éxito",
                data: {
                    consulta_vacunas
                },
                fechaHoy: fechaHoy
            });
        }
        else {
             response.badRequest({
                estado: "Fallo",
                data: "No hay vacunas asociadas al usuario: " + params.idUsuario
            });
           // return { "error": "No hay vacunas asociadas al usuario: " + params.idUsuario };
        }
    }
    async dameVacunasPendientesPersona({ params, response }) {
        const fechaHoy = new Date();
        const consulta_persona = await Database_1.default.from('usuarios')
            .select('persona').where('id', '=', params.idUsuario);
        if (consulta_persona.length > 0) {
            var arr_consulta_vacunas = [];
            const consulta_vacunas = await Database_1.default.from('vacunas as v')
                .select('v.id as vacunaId', 'v.nombre as vacunaNombre', 'v.descripcion as descripcionVacuna', 'v.cantidad_dosis as cantidadDosis', 'rvc.persona as idPersona', 'rvc.f_inoculacion as fInoculacion', 'v.periodo as periodo', 'rvc.f_renovacion as fRenovacion')
                .innerJoin('r_vacunas_personas as rvc', 'v.id', '=', 'rvc.vacuna')
                .where('rvc.persona', '=', consulta_persona[0]['persona']);
            for (var i = 0; i < consulta_vacunas.length; i++) {
                if (consulta_vacunas[i]['fInoculacion'] <= fechaHoy && consulta_vacunas[i]['fRenovacion'] >= fechaHoy) {
                    arr_consulta_vacunas.push(consulta_vacunas[i]);
                }
            }
            response.ok({
                estado: "Éxito",
                data: {
                    arr_consulta_vacunas
                },
                fechaHoy: fechaHoy
            });
        }
        else {
            response.badRequest({
                estado: "Fallo",
                data: "No hay vacunas pendientes asociadas al usuario: " + params.idUsuario
            });
           // return { "error": "No hay vacunas pendientes asociadas al usuario: " + params.idUsuario };
        }
    }
    async creaPais({ response, request }) {
        const payload = request.all();
        let datosPais = {
            nombre: payload.nombrePais,
        };
        const pais = await Pais_1.default.create(datosPais);
        response.ok({ data: "País " + pais.nombre + " introducido correctamente con id: " + pais.id });
    }
    async creaCV({ response, request }) {
        const payload = request.all();
        let datosCV = {
            nombre: payload.nombreCV
        };
        const cv = await CentrosVacunaciones_1.default.create(datosCV);
        response.ok({ data: "Centro de vacunación " + cv.nombre + " introducido correctamente con id: " + cv.id });
    }
    async creaEmbajadaConsulado({ response, request }) {
        const payload = request.all();
        let datosEmbajadaCopnsulado = {
            nombre: payload.nombreEC
        };
        const ec = await EmbajadasConsulados_1.default.create(datosEmbajadaCopnsulado);
        response.ok({ data: "Embajada/consulado " + ec.nombre + " introducido correctamente con id: " + ec.id });
    }
    async creaTiposViaje({ response, request }) {
        const payload = request.all();
        let datosTV = {
            nombre: payload.nombreTV
        };
        const tv = await TiposViaje_1.default.create(datosTV);
        response.ok({ data: "Tipo de viaje " + tv.nombre + " introducido correctamente con id: " + tv.id });
    }
    async creaMotivosViaje({ response, request }) {
        const payload = request.all();
        let datosMV = {
            nombre: payload.nombreMV
        };
        const mv = await MotivosViaje_1.default.create(datosMV);
        response.ok({ data: "Motivo de viaje " + mv.nombre + " introducido correctamente con id: " + mv.id });
    }
}
exports.default = ApiController;
//# sourceMappingURL=ApiController.js.map